(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14034,        431]*)
(*NotebookOutlinePosition[     14876,        458]*)
(*  CellTagsIndexPosition[     14832,        454]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 3.2  .1 . \ Baker\ 1978, \ 
      p . \ 766\ *) \[IndentingNewLine] (*\ \[Lambda] = 1, \ h = 1/5, \ 
      1/10, \ 1/20\ *) \[IndentingNewLine] (*\ 
      Use\ formula\ \((2.2  .10)\)\ *) \[IndentingNewLine]\(\[Lambda] = 
        1.0;\)\), "\[IndentingNewLine]", 
    \(\(a = 1.  + \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(b = 1.  - \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma] = a/b;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ 2*Exp[\(-x\)] - 1;\)\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/5;\)\), "\[IndentingNewLine]", 
    \(phitil[
        h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/b\)}], "Input"],

Cell[BoxData[
    \(0.8194016735066263`\)], "Output"],

Cell[BoxData[
    \(0.6716893630806708`\)], "Output"],

Cell[BoxData[
    \(0.550934977228347`\)], "Output"],

Cell[BoxData[
    \(0.45229236777507975`\)], "Output"],

Cell[BoxData[
    \(0.37180284295669946`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/10;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(0.8188985201721409`\)], "Output"],

Cell[BoxData[
    \(0.6706623475125558`\)], "Output"],

Cell[BoxData[
    \(0.5493422515001962`\)], "Output"],

Cell[BoxData[
    \(0.45006923995846376`\)], "Output"],

Cell[BoxData[
    \(0.36885914967523703`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/20;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          11\ h] = \[Gamma]*phitil[10\ h] + \((f[11\ h] - f[10\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        12\ h] = \[Gamma]*phitil[11\ h] + \((f[12\ h] - f[11\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          13\ h] = \[Gamma]*phitil[12\ h] + \((f[13\ h] - f[12\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          14\ h] = \[Gamma]*phitil[13\ h] + \((f[14\ h] - f[13\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          15\ h] = \[Gamma]*phitil[14\ h] + \((f[15\ h] - f[14\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        16\ h] = \[Gamma]*phitil[15\ h] + \((f[16\ h] - f[15\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          17\ h] = \[Gamma]*phitil[16\ h] + \((f[17\ h] - f[16\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          18\ h] = \[Gamma]*phitil[17\ h] + \((f[18\ h] - f[17\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          19\ h] = \[Gamma]*phitil[18\ h] + \((f[19\ h] - f[18\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        20\ h] = \[Gamma]*phitil[19\ h] + \((f[20\ h] - f[19\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(0.8187726972650083`\)], "Output"],

Cell[BoxData[
    \(0.6704056199126537`\)], "Output"],

Cell[BoxData[
    \(0.548944276649549`\)], "Output"],

Cell[BoxData[
    \(0.44951399786847496`\)], "Output"],

Cell[BoxData[
    \(0.36812429806411023`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ \[Lambda] = \(-1\), \ h = 1/5, \ 1/10, \ 
      1/20\ *) \[IndentingNewLine] (*\ 
      Use\ formula\ \((2.2  .10)\)\ *) \[IndentingNewLine]\(\[Lambda] = \
\(-1.0\);\)\), "\[IndentingNewLine]", 
    \(\(a = 1.  + \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(b = 1.  - \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma] = a/b;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ 2*Exp[x] - 1;\)\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/5;\)\), "\[IndentingNewLine]", 
    \(phitil[
        h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/b\)}], "Input"],

Cell[BoxData[
    \(1.326481444114609`\)], "Output"],

Cell[BoxData[
    \(1.7152392865438855`\)], "Output"],

Cell[BoxData[
    \(2.18101478830016`\)], "Output"],

Cell[BoxData[
    \(2.7417221953229243`\)], "Output"],

Cell[BoxData[
    \(3.4191598909427916`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/10;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.2212350190668726`\)], "Output"],

Cell[BoxData[
    \(1.491482510417231`\)], "Output"],

Cell[BoxData[
    \(1.8215884506241995`\)], "Output"],

Cell[BoxData[
    \(2.2248011467450888`\)], "Output"],

Cell[BoxData[
    \(2.7173029372647233`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/20;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          11\ h] = \[Gamma]*phitil[10\ h] + \((f[11\ h] - f[10\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        12\ h] = \[Gamma]*phitil[11\ h] + \((f[12\ h] - f[11\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          13\ h] = \[Gamma]*phitil[12\ h] + \((f[13\ h] - f[12\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          14\ h] = \[Gamma]*phitil[13\ h] + \((f[14\ h] - f[13\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          15\ h] = \[Gamma]*phitil[14\ h] + \((f[15\ h] - f[14\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        16\ h] = \[Gamma]*phitil[15\ h] + \((f[16\ h] - f[15\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          17\ h] = \[Gamma]*phitil[16\ h] + \((f[17\ h] - f[16\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          18\ h] = \[Gamma]*phitil[17\ h] + \((f[18\ h] - f[17\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          19\ h] = \[Gamma]*phitil[18\ h] + \((f[19\ h] - f[18\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        20\ h] = \[Gamma]*phitil[19\ h] + \((f[20\ h] - f[19\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.0375829036311268`\)], "Output"],

Cell[BoxData[
    \(1.1441296145298614`\)], "Output"],

Cell[BoxData[
    \(1.314902610120687`\)], "Output"],

Cell[BoxData[
    \(1.550715619411016`\)], "Output"],

Cell[BoxData[
    \(1.8569852708389125`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 581, 10, 155, "Input"],
Cell[2323, 63, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2395, 69, 610, 15, 107, "Input"],
Cell[3008, 86, 53, 1, 26, "Output"],
Cell[3064, 89, 53, 1, 26, "Output"],
Cell[3120, 92, 52, 1, 26, "Output"],
Cell[3175, 95, 54, 1, 26, "Output"],
Cell[3232, 98, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3323, 104, 1306, 32, 203, "Input"],
Cell[4632, 138, 53, 1, 26, "Output"],
Cell[4688, 141, 53, 1, 26, "Output"],
Cell[4744, 144, 53, 1, 26, "Output"],
Cell[4800, 147, 54, 1, 26, "Output"],
Cell[4857, 150, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4948, 156, 2616, 62, 363, "Input"],
Cell[7567, 220, 53, 1, 26, "Output"],
Cell[7623, 223, 53, 1, 26, "Output"],
Cell[7679, 226, 52, 1, 26, "Output"],
Cell[7734, 229, 54, 1, 26, "Output"],
Cell[7791, 232, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7882, 238, 41, 1, 27, "Input"],
Cell[7926, 241, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8005, 247, 498, 9, 139, "Input"],
Cell[8506, 258, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8578, 264, 610, 15, 107, "Input"],
Cell[9191, 281, 52, 1, 26, "Output"],
Cell[9246, 284, 53, 1, 26, "Output"],
Cell[9302, 287, 51, 1, 26, "Output"],
Cell[9356, 290, 53, 1, 26, "Output"],
Cell[9412, 293, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9502, 299, 1306, 32, 203, "Input"],
Cell[10811, 333, 53, 1, 26, "Output"],
Cell[10867, 336, 52, 1, 26, "Output"],
Cell[10922, 339, 53, 1, 26, "Output"],
Cell[10978, 342, 53, 1, 26, "Output"],
Cell[11034, 345, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11124, 351, 2616, 62, 363, "Input"],
Cell[13743, 415, 53, 1, 26, "Output"],
Cell[13799, 418, 53, 1, 26, "Output"],
Cell[13855, 421, 52, 1, 26, "Output"],
Cell[13910, 424, 52, 1, 26, "Output"],
Cell[13965, 427, 53, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

